/*
 * AutoGeneratedTileset.cpp
 *
 *  Created on: Nov 27, 2013
 *      Author: cfyz
 */

#include "Common.hpp"

void TestAutoGenerated()
{
	terminal_set("window.title='Omni: auto-generated tileset'");

	int hoffset = 40;
	int cell_width = terminal_state(TK_CELL_WIDTH);
	int cell_height = terminal_state(TK_CELL_HEIGHT);
	auto setup_cellsize = [&]{terminal_setf("window.cellsize=%dx%d", cell_width, cell_height);};

	while (true)
	{
		terminal_clear();
		terminal_color("white");

		terminal_printf(2, 1, "[color=orange]Cell size:[/color] %dx%d", cell_width, cell_height);
		terminal_printf(2, 3, "[color=orange]TIP:[/color] Use arrow keys\nto change cell size");

		for (int j=0; j<16; j++)
		{
			terminal_printf(hoffset+6+j*2, 1, "[color=orange]%X", j);
		}
		for (int code=0x2500, y=0; code<=0x259F; code++)
		{
			if (code%16 == 0) terminal_printf(hoffset, 2+y*1, " [color=orange]%04X", code);
			terminal_put(hoffset+6+(code%16)*2, 2+y*1, code);
			if ((code+1)%16 == 0) y += 1;
		}

		terminal_print
		(
			2, 6,
			L"┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐\n"
			L"│Z││A││ ││W││A││R││U││D││O│\n"
			L"└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘\n"
		);

		terminal_refresh();

		int key = terminal_read();

		if (key == TK_CLOSE || key == TK_ESCAPE)
		{
			break;
		}
		else if (key == TK_LEFT && cell_width > 4)
		{
			cell_width -= 1;
			setup_cellsize();
		}
		else if (key == TK_RIGHT && cell_width < 24)
		{
			cell_width += 1;
			setup_cellsize();
		}
		else if (key == TK_DOWN && cell_height < 24)
		{
			cell_height += 1;
			setup_cellsize();
		}
		else if (key == TK_UP && cell_height > 4)
		{
			cell_height -= 1;
			setup_cellsize();
		}
	}

	terminal_set("window.cellsize=auto");
}
